<?php

namespace Iyzipay;

class Options
{
    private $apiKey;
    private $secretKey;
    private $baseUrl;

    public function getApiKey()
    {
        return $this->apiKey;
    }

    public function setApiKey($apiKey)
    {
        $this->apiKey = $apiKey;
    }

    public function getSecretKey()
    {
        return $this->secretKey;
    }

    public function setSecretKey($secretKey)
    {
        $this->secretKey = $secretKey;
    }

    public function getBaseUrl()
    {
        return $this->baseUrl;
    }

    public function setBaseUrl($baseUrl)
    {
        $this->baseUrl = $baseUrl;
    }

    public function toPKIRequestString()
    {
        return RequestStringBuilder::create()
            ->appendPrice("apiKey", $this->getApiKey())
            ->appendPrice("secretKey", $this->getSecretKey())
            ->append("baseUrl", $this->getBaseUrl())
            ->getRequestString();
    }

}