<?php

//header('Content-type: text/html; charset=utf-8');

class DemoPage
{

    private $public_key = "Magaza Public Key Bilginiz";
    private $private_key = "Magaza Private Key Bilginiz";
//    private $vendor_id = 100;

    private $products = array();
    private $shipping_address = array();
    private $invoice_address = array();
    private $card = array();
    private $purchaser = array();
}

class iParaPayment
{
    // Istek Adresleri
    private $auth_url = "https://api.ipara.com/rest/payment/auth";
    private $three_d_url = "https://www.ipara.com/3dgate";
    private $version = "1.0";

    // Istek degiskenleri
    private $mode;
    private $three_d;
    private $order_id;
    private $installment;
    private $amount;
    private $vendor_id;
    private $echo;
    private $products;
    private $shipping_address;
    private $invoice_address;
    private $card;
    private $purchaser;
    private $private_key;
    private $public_key;
    private $success_url;
    private $failure_url;
    private $three_d_secure_code;

    public function __set($property, $value)
    {
        if (property_exists($this, $property)) {
            $this->$property = $value;
        }
        return $this;
    }

    // API ile Odeme Metodu
    public function pay()
    {
        $this->three_d = "false";

        if (isset($this->three_d_secure_code)) {
            $this->three_d = "true";
        }

        $xml_data = $this->prepareXML();
        $output = $this->calliParaAuthService($xml_data);
        if ($output == NULL) {
            throw new Exception("deme cevab bo");
        }
        $response = $this->prepareResponse($output);
        $this->validateResponse($response);

        $response['amount'] = number_format((float)($response['amount'] / 100), 2, '.', '');

        return $response;
    }

    // 3D Secure ile Odeme Methodu

    private function prepareXML()
    {
        $xml_data_product_part = "";
        foreach ($this->products as $product) {
            $xml_data_product_part .= "<product>\n" .
                "	<productCode>" . urlencode($product['code']) . "</productCode>\n" .
                "	<productName>" . urlencode($product['title']) . "</productName>\n" .
                "	<quantity>" . $product['quantity'] . "</quantity>\n" .
                "	<price>" . number_format((float)$product['price'], 2, '', '') . "</price>\n" .
                "</product>\n";
        }

        $three_d_secure_code_part = "";
        if ($this->three_d == "true") {
            $three_d_secure_code_part = "    <threeDSecureCode>" . $this->three_d_secure_code . "</threeDSecureCode>\n";
        }

        $vendor_id_part = "";
        if ($this->vendor_id != NULL) {
            $vendor_id_part .= "    <vendorId>" . $this->vendor_id . "</vendorId>\n";
        }

        $xml_data = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" .
            "<auth>\n" .
            "    <threeD>" . $this->three_d . "</threeD>\n" .
            "    <orderId>" . $this->order_id . "</orderId>\n" .
            "    <amount>" . number_format((float)$this->amount, 2, '', '') . "</amount>\n" .
            "    <cardOwnerName>" . urlencode($this->card['owner_name']) . "</cardOwnerName>\n" .
            "    <cardNumber>" . $this->card['number'] . "</cardNumber>\n" .
            "    <cardExpireMonth>" . $this->card['expire_month'] . "</cardExpireMonth>\n" .
            "    <cardExpireYear>" . $this->card['expire_year'] . "</cardExpireYear>\n" .
            "    <installment>" . $this->installment . "</installment>\n" .
            "    <cardCvc>" . $this->card['cvc'] . "</cardCvc>\n" .
            "    <mode>" . $this->mode . "</mode>\n" .
            $three_d_secure_code_part .
            $vendor_id_part .
            "    <products>\n" .
            $xml_data_product_part .
            "    </products>\n" .
            "    <purchaser>\n" .
            "        <name>" . urlencode($this->purchaser['name']) . "</name>\n" .
            "        <surname>" . urlencode($this->purchaser['surname']) . "</surname>\n" .
            "        <birthDate>" . $this->purchaser['birthdate'] . "</birthDate>\n" .
            "        <email>" . $this->purchaser['email'] . "</email>\n" .
            "        <gsmNumber>" . urlencode($this->purchaser['gsm_number']) . "</gsmNumber>\n" .
            "        <tcCertificate>" . urlencode($this->purchaser['tc_certificate_number']) . "</tcCertificate>\n" .
            "        <clientIp>" . $this->get_client_ip() . "</clientIp>\n" .
            "        <invoiceAddress>\n" .
            "            <name>" . urlencode($this->invoice_address['name']) . "</name>\n" .
            "            <surname>" . urlencode($this->invoice_address['surname']) . "</surname>\n" .
            "            <address>" . urlencode($this->invoice_address['address']) . "</address>\n" .
            "            <zipcode>" . urlencode($this->invoice_address['zipcode']) . "</zipcode>\n" .
            "            <city>" . urlencode($this->invoice_address['city_code']) . "</city>\n" .
            "            <tcCertificate>" . urlencode($this->invoice_address['tc_certificate_number']) . "</tcCertificate>\n" .
            "            <country>" . urlencode($this->invoice_address['country_code']) . "</country>\n" .
            "            <taxNumber>" . urlencode($this->invoice_address['tax_number']) . "</taxNumber>\n" .
            "            <taxOffice>" . urlencode($this->invoice_address['tax_office']) . "</taxOffice>\n" .
            "            <companyName>" . urlencode($this->invoice_address['company_name']) . "</companyName>\n" .
            "            <phoneNumber>" . urlencode($this->invoice_address['phone_number']) . "</phoneNumber>\n" .
            "        </invoiceAddress>\n" .
            "        <shippingAddress>\n" .
            "            <name>" . urlencode($this->shipping_address['name']) . "</name>\n" .
            "            <surname>" . urlencode($this->shipping_address['surname']) . "</surname>\n" .
            "            <address>" . urlencode($this->shipping_address['address']) . "</address>\n" .
            "            <zipcode>" . urlencode($this->shipping_address['zipcode']) . "</zipcode>\n" .
            "            <city>" . urlencode($this->shipping_address['city_code']) . "</city>\n" .
            "            <country>" . urlencode($this->shipping_address['country_code']) . "</country>\n" .
            "            <phoneNumber>" . urlencode($this->shipping_address['phone_number']) . "</phoneNumber>\n" .
            "        </shippingAddress>\n" .
            "    </purchaser>\n" .
            "</auth>";
        return $xml_data;
    }

    private function get_client_ip()
    {
        if (getenv('HTTP_CLIENT_IP'))
            $ipaddress = getenv('HTTP_CLIENT_IP');
        else if (getenv('HTTP_X_FORWARDED_FOR'))
            $ipaddress = getenv('HTTP_X_FORWARDED_FOR');
        else if (getenv('HTTP_X_FORWARDED'))
            $ipaddress = getenv('HTTP_X_FORWARDED');
        else if (getenv('HTTP_FORWARDED_FOR'))
            $ipaddress = getenv('HTTP_FORWARDED_FOR');
        else if (getenv('HTTP_FORWARDED'))
            $ipaddress = getenv('HTTP_FORWARDED');
        else if (getenv('REMOTE_ADDR'))
            $ipaddress = getenv('REMOTE_ADDR');
        else
            $ipaddress = 'UNKNOWN';

        return $ipaddress;
    }

    private function calliParaAuthService($xml_data)
    {
        $timestamp = date("Y-m-d H:i:s");
        $token = "";
        if ($this->three_d == "false") {
            $hash_text = $this->private_key . $this->order_id . number_format((float)$this->amount, 2, '', '') . $this->mode . $this->card['owner_name'] .
                $this->card['number'] . $this->card['expire_month'] . $this->card['expire_year'] . $this->card['cvc'] .
                $this->purchaser['name'] . $this->purchaser['surname'] . $this->purchaser['email'] . $timestamp;
            $token = $this->public_key . ":" . base64_encode(sha1($hash_text, true));
        } else if ($this->three_d == "true") {
            $hash_text = $this->private_key . $this->order_id . number_format((float)$this->amount, 2, '', '') . $this->mode .
                $this->three_d_secure_code . $timestamp;
            $token = $this->public_key . ":" . base64_encode(sha1($hash_text, true));
        }
        $ch = curl_init($this->auth_url);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array("Content-Type: application/xml", "transactionDate: " . $timestamp, "version: " . $this->version, "token: " . $token));
        curl_setopt($ch, CURLOPT_POSTFIELDS, $xml_data);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        $output = curl_exec($ch);
        curl_close($ch);
        return $output;
    }

    private function prepareResponse($output)
    {
        $xml_response = new SimpleXMLElement($output);
        if ($xml_response == NULL) {
            throw new Exception("deme cevab xml formatnda deil");
        }
        $response = array();
        $response['result'] = $xml_response->result;
        $response['order_id'] = $xml_response->orderId;
        $response['amount'] = $xml_response->amount;
        $response['mode'] = $xml_response->mode;
        $response['public_key'] = $xml_response->publicKey;
        $response['echo'] = $xml_response->echo;
        $response['error_code'] = $xml_response->errorCode;
        $response['error_message'] = $xml_response->errorMessage;
        $response['transaction_date'] = $xml_response->transactionDate;
        $response['hash'] = $xml_response->hash;
        return $response;
    }

    // 3D Secure Sonucunun Islenmesi ve Hash Gecerlilik Kontrolu

    private function validateResponse($response)
    {
        if ($response['hash'] != NULL) {
            $hash_text = $response['order_id'] . $response['result'] . $response['amount'] . $response['mode'] . $response['error_code'] .
                $response['error_message'] . $response['transaction_date'] . $response['public_key'] . $this->private_key;
            $hash = base64_encode(sha1($hash_text, true));
            if ($hash != $response['hash']) {
                throw new Exception("deme cevab hash dorulamas hatal. [result : " . $response['result'] . ",error_code : " . $response['error_code'] . ",error_message : " . $response['error_message'] . "]");
            }
        } else {
            throw new Exception("deme cevab hash dorulamas hatal.");
        }
    }

    public function payThreeD()
    {
        $timestamp = date("Y-m-d H:i:s");
        $hash_text = $this->private_key . $this->order_id . number_format((float)$this->amount, 2, '', '') . $this->mode . $this->card['owner_name'] .
            $this->card['number'] . $this->card['expire_month'] . $this->card['expire_year'] . $this->card['cvc'] .
            $this->purchaser['name'] . $this->purchaser['surname'] . $this->purchaser['email'] . $timestamp;
        $token = $this->public_key . ":" . base64_encode(sha1($hash_text, true));

        $treed_form_data = "";
        $treed_form_data.="<form action=\"" . $this->three_d_url . "\" method=\"post\" id=\"frm_3d\"  name=\"frm_3d\"   target=\"iframe_3d\" />";
        $treed_form_data.="<input type=\"hidden\" name=\"orderId\" value=\"" . $this->order_id . "\"/>";
        $treed_form_data.="<input type=\"hidden\" name=\"amount\" value=\"" . number_format((float)$this->amount, 2, '', '') . "\"/>";
        $treed_form_data.="<input type=\"hidden\" name=\"cardOwnerName\" value=\"" . urlencode($this->card['owner_name']) . "\"/>";
        $treed_form_data.="<input type=\"hidden\" name=\"cardNumber\" value=\"" . $this->card['number'] . "\"/>";
        $treed_form_data.="<input type=\"hidden\" name=\"cardExpireMonth\" value=\"" . $this->card['expire_month'] . "\"/>";
        $treed_form_data.="<input type=\"hidden\" name=\"cardExpireYear\" value=\"" . $this->card['expire_year'] . "\"/>";
        $treed_form_data.="<input type=\"hidden\" name=\"installment\" value=\"" . $this->installment . "\"/>";
        $treed_form_data.="<input type=\"hidden\" name=\"cardCvc\" value=\"" . $this->card['cvc'] . "\"/>";
        $treed_form_data.="<input type=\"hidden\" name=\"mode\" value=\"" . $this->mode . "\"/>";
        $treed_form_data.="<input type=\"hidden\" name=\"purchaserName\" value=\"" . urlencode($this->purchaser['name']) . "\"/>";
        $treed_form_data.="<input type=\"hidden\" name=\"purchaserSurname\" value=\"" . urlencode($this->purchaser['surname']) . "\"/>";
        $treed_form_data.="<input type=\"hidden\" name=\"purchaserEmail\" value=\"" . $this->purchaser['email'] . "\"/>";
        $treed_form_data.="<input type=\"hidden\" name=\"successUrl\" value=\"" . $this->success_url . "\"/>";
        $treed_form_data.="<input type=\"hidden\" name=\"failureUrl\" value=\"" . $this->failure_url . "\"/>";
        $treed_form_data.="<input type=\"hidden\" name=\"echo\" value=\"" . $this->echo . "\"/>";
        $treed_form_data.="<input type=\"hidden\" name=\"version\" value=\"" . $this->version . "\"/>";
        $treed_form_data.="<input type=\"hidden\" name=\"transactionDate\" value=\"" . $timestamp . "\"/>";
        $treed_form_data.="<input type=\"hidden\" name=\"token\" value=\"" . $token . "\"/>";
        $treed_form_data.="<input type=\"submit\" value=\"de\" style=\"display:none;\"/>";
        $treed_form_data.="<noscript>";
        $treed_form_data.="<br/>";
        $treed_form_data.="<br/>";
        $treed_form_data.="<center>";
        $treed_form_data.="<h1>3D Secure Ynlendirme lemi</h1>";
        $treed_form_data.="<h2>Javascript internet taraycnzda kapatlm veya desteklenmiyor.<br/></h2>";
        $treed_form_data.="<h3>Ltfen banka 3D Secure sayfasna ynlenmek iin tklaynz.</h3>";
        $treed_form_data.="<input type=\"submit\" value=\"3D Secure Sayfasna Ynlen\">";
        $treed_form_data.="</center>";
        $treed_form_data.="</noscript>";
        $treed_form_data.="</form>";
        $treed_form_data.="</body>";
        $treed_form_data.="<script>document.getElementById(\"three_d_form\").submit(;</script>";
        return $treed_form_data;
    }

    public function getThreeDResponse($output)
    {
        $response = array();
        $response['result'] = $output['result'];
        $response['order_id'] = $output['orderId'];
        $response['amount'] = $output['amount'];
        $response['mode'] = $output['mode'];
        if (isset($output['publicKey'])) {
            $response['public_key'] = $output['publicKey'];
        } else {
            $response['public_key'] = "";
        }
        if (isset($output['echo'])) {
            $response['echo'] = $output['echo'];
        }
        if (isset($output['errorCode'])) {
            $response['error_code'] = $output['errorCode'];
        } else {
            $response['errorCode'] = "";
        }
        if (isset($output['errorMessage'])) {
            $response['error_message'] = $output['errorMessage'];
        } else {
            $response['error_message'] = "";
        }
        if (isset($output['transactionDate'])) {
            $response['transaction_date'] = $output['transactionDate'];
        } else {
            $response['transaction_date'] = "";
        }
        if (isset($output['hash'])) {
            $response['hash'] = $output['hash'];
        } else {
            $response['hash'] = "";
        }
        if (isset($output['threeDSecureCode'])) {
            $response['three_d_secure_code'] = $output['threeDSecureCode'];
        } else {
            $response['three_d_secure_code'] = "";
        }
        try {
            $this->validateResponse($response);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }

        $response['amount'] = number_format((float)($response['amount'] / 100), 2, '.', '');

        return $response;
    }
}

?>