// if gbtx has not yet been initialized, wait a second and try again
// once gbtx has been initialized, then install the table command
// handlers.			
installTableUpdater = function() {
	var xjxReady = false;
	try {
		if (gbtx) xjxReady = true;
	} catch (e) {
	}
	if (false == xjxReady) {
		setTimeout('installTableUpdater();', 1000);
		return;
	}

	try {
		if ('undefined' == typeof gbtx.ext.tables)
			gbtx.ext.tables = {};
	} catch (e) {
		gbtx.ext = {};
		gbtx.ext.tables = {};
	}

	// internal helper functions
	gbtx.ext.tables.internal = {};
	gbtx.ext.tables.internal.createTable = function(table) {
		if ('string' != typeof (table))
			throw { name: 'TableError', message: 'Invalid table name specified.' }
		var newTable = document.createElement('table');
		newTable.id = table;
		// save the column configuration
		gbtx.ext.tables.appendHeader(table + '_header', newTable);
		gbtx.ext.tables.appendBody(table + '_body', newTable);
		gbtx.ext.tables.appendFooter(table + '_footer', newTable);
		return newTable;
	}
	gbtx.ext.tables.internal.createRow = function(objects, id) {
		var row = document.createElement('tr');
		if (null != id)
			row.id = id;
		return row;
	}
	gbtx.ext.tables.internal.createCell = function(objects, id) {
		var cell = document.createElement('td');
		if (null != id)
			cell.id = id;
		cell.innerHTML = '...';
		return cell;
	}
	gbtx.ext.tables.internal.getColumnNumber = function(objects, cell) {
		var position;
		var columns = objects.header.getElementsByTagName('td');
		for (var column = 0; column < columns.length; ++column)
			if (columns[column].id == cell)
				return column;
		throw { name: 'TableError', message: 'Column not found. (getColumnNumber)' }
		return undefined;
	}
	gbtx.ext.tables.internal.objectify = function(params, required) {
		if ('undefined' == typeof params.source)
			return false;
		var source = params.source;
		if ('string' == typeof (source))
			source = gbtx.$(source);
		if ('TBODY' == source.nodeName) {
			params.table = source.parentNode;
		} else if ('TABLE' == source.nodeName) {
			params.table = source;
		} else if ('TR' == source.nodeName) {
			params.row = source;
			params.body = source.parentNode;
			params.table = source.parentNode.parentNode;
		} else if ('TD' == source.nodeName) {
			params.cell = source;
			params.row = source.parentNode;
			params.columns = params.row.getElementsByTagName('TD');
			for (var column = 0; 'undefined' == typeof params.column && column < params.columns.length; ++column)
				if (params.cell.id == params.columns[column].id)
					params.column = column;
			params.table = source.parentNode.parentNode.parentNode;
		} else if ('THEAD' == source.nodeName) {
			params.table = source.parentNode;
		} else if ('TFOOT' == source.nodeName) {
			params.table = source.parentNode;
		} else
			params.source = source;
		
		var bodies = params.table.getElementsByTagName('TBODY');
		if (0 < bodies.length)
			params.body = bodies[0];
		var headers = params.table.getElementsByTagName('THEAD');
		if (0 < headers.length)
			params.header = headers[0];
		var feet = params.table.getElementsByTagName('TFOOT');
		if (0 < feet.length)
			params.footer = feet[0];
		if ('undefined' != typeof params.body)
			params.rows = params.body.getElementsByTagName('TR');
		if ('undefined' != typeof params.row)
			params.cells = params.row.getElementsByTagName('TD');
		if ('undefined' != typeof params.header)
			params.columns = params.header.getElementsByTagName('TD');
		
		if ('undefined' == typeof required)
			return true;
		
		for (var index = 0; index < required.length; ++index) {
			var require = required[index];
			var is_defined = false;
			eval('is_defined = (undefined != params.' + require + ');');
			if (false == is_defined)
				throw { name: 'TableError', message: 'Unable to locate required object [' + require + '].' };
		}
		
		return true;
	}
	// table
	gbtx.ext.tables.append = function(table, parent) {
		if ('string' == typeof (parent))
			parent = gbtx.$(parent);
		parent.appendChild(gbtx.ext.tables.internal.createTable(table));
	}
	gbtx.ext.tables.insert = function(table, parent, before) {
		if ('string' == typeof (parent))
			parent = gbtx.$(parent);
		if ('string' == typeof (before))
			before = gbtx.$(before);
		parent.insertBefore(gbtx.ext.tables.internal.createTable(table), before);
	}
	gbtx.ext.tables.remove = function(table) {
		var objects = { source: table };
		gbtx.ext.tables.internal.objectify(objects, ['table']);
		objects.table.parentNode.removeChild(objects.table);
	}
	gbtx.ext.tables.appendHeader = function(id, table) {
		var objects = { source: table };
		gbtx.ext.tables.internal.objectify(objects, ['table']);
		if ('undefined' == typeof objects.header) {
			var thead = document.createElement('thead');
			if (null != id)
				thead.id = id;
			objects.header = thead;
			thead.appendChild(gbtx.ext.tables.internal.createRow(objects, null));
			if ('undefined' == typeof objects.table.firstChild)
				table.appendChild(thead);
			else
				table.insertBefore(thead, table.firstChild);
		}
	}
	gbtx.ext.tables.appendBody = function(id, table) {
		var objects = { source: table };
		gbtx.ext.tables.internal.objectify(objects, ['table']);
		if ('undefined' == typeof objects.body) {
			var tbody = document.createElement('tbody');
			if (null != id)
				tbody.id = id;
			objects.body = tbody;
		}
		if ('undefined' != typeof objects.rows) {
			for (var rn = 0; rn < objects.rows.length; ++rn) {
				var row = objects.rows[rn];
				objects.table.removeChild(row);
				objects.body.appendChild(row);
			}
		}
		if ('undefined' != typeof objects.footer)
			objects.table.insertBefore(objects.body, objects.footer);
		else
			objects.table.appendChild(objects.body);
	}
	gbtx.ext.tables.appendFooter = function(id, table) {
		var objects = { source: table }
		gbtx.ext.tables.internal.objectify(objects, ['table']);
		if ('undefined' == typeof objects.footer) {
			var tfoot = document.createElement('tfoot');
			if (null != id)
				tfoot.id = id;
			objects.footer = tfoot;
			tfoot.appendChild(gbtx.ext.tables.internal.createRow(objects, null));
			objects.table.appendChild(tfoot);
		}
	}
	// rows
	gbtx.ext.tables.rows = {}
	gbtx.ext.tables.rows.internal = {}
	gbtx.ext.tables.rows.internal.calculateRow = function(objects, position) {
		if ('undefined' == typeof position)
			throw { name: 'TableError', message: 'Missing row number / id.' }
		if ('undefined' == typeof objects.row)
			if ('undefined' != typeof objects.rows)
				if ('undefined' != typeof objects.rows[position])
					objects.row = objects.rows[position];
		if ('undefined' == typeof objects.row)
			objects.row = gbtx.$(position);
		if ('undefined' == typeof objects.row)
			throw { name: 'TableError', message: 'Invalid row number / row id specified.' }
	}
	gbtx.ext.tables.rows.append = function(id, table) {
		var objects = { source: table }
		gbtx.ext.tables.internal.objectify(objects, ['table', 'body']);
		var row = gbtx.ext.tables.internal.createRow(objects, id);
		if ('undefined' != typeof objects.columns) {
			for (var column = 0; column < objects.columns.length; ++column) {
				var cell = gbtx.ext.tables.internal.createCell(objects, null);
				cell.innerHTML = '...';
				row.appendChild(cell);
			}
		}
		objects.body.appendChild(row);
	}
	gbtx.ext.tables.rows.insert = function(id, source, position) {
		var objects = { source: source }
		gbtx.ext.tables.internal.objectify(objects, ['table', 'body']);
		if ('undefined' == typeof objects.row)
			gbtx.ext.tables.rows.internal.calculateRow(objects, position);
		var row = gbtx.ext.tables.internal.createRow(objects, id);
		if ('undefined' != typeof objects.columns) {
			for (var column = 0; column < objects.columns.length; ++column) {
				var cell = gbtx.ext.tables.internal.createCell(objects, null);
				cell.innerHTML = '...';
				row.appendChild(cell);
			}
		}
		objects.body.insertBefore(row, objects.row);
	}
	gbtx.ext.tables.rows.replace = function(id, source, position) {
		var objects = { source: source }
		gbtx.ext.tables.internal.objectify(objects, ['table', 'body']);
		if ('undefined' == typeof objects.row)
			gbtx.ext.tables.rows.internal.calculateRow(objects, position);
		var row = gbtx.ext.tables.internal.createRow(objects, id);
		if ('undefined' != typeof objects.columns) {
			for (var column = 0; column < objects.columns.length; ++column) {
				var cell = gbtx.ext.tables.internal.createCell(objects, null);
				cell.innerHTML = '...';
				row.appendChild(cell);
			}
		}
		objects.body.insertBefore(row, objects.row);
		objects.body.removeChild(objects.row);
	}
	gbtx.ext.tables.rows.remove = function(source, position) {
		var objects = { source: source }
		gbtx.ext.tables.internal.objectify(objects, ['table', 'body']);
		if ('undefined' == typeof objects.row)
			gbtx.ext.tables.rows.internal.calculateRow(objects, position);
		objects.body.removeChild(objects.row);
	}
	gbtx.ext.tables.rows.assignProperty = function(value, source, position, property) {
		var objects = { source: source }
		gbtx.ext.tables.internal.objectify(objects, ['table', 'body', 'header']);
		if ('undefined' == typeof objects.row)
			gbtx.ext.tables.rows.internal.calculateRow(objects, position);
		if ('undefined' != typeof property)
			eval('objects.row.' + property + ' = value;');
	}
	gbtx.ext.tables.rows.assign = function(values, source, position, start_column) {
		var objects = { source: source }
		gbtx.ext.tables.internal.objectify(objects, ['table', 'body', 'header']);
		if ('undefined' == typeof objects.row)
			gbtx.ext.tables.rows.internal.calculateRow(objects, position);
		if ('undefined' == typeof start_column)
			start_column = 0;
		for (var column = 0; column < values.length; ++column)
			gbtx.ext.tables.cells.assign(values[column], objects.row, start_column + column);
	}
	// columns
	gbtx.ext.tables.columns = {}
	gbtx.ext.tables.columns.internal = {}
	gbtx.ext.tables.columns.internal.calculateColumn = function(objects, position) {
		if ('undefined' == typeof position)
			throw { name: 'TableError', message: 'Missing column number / id.' }
		if ('undefined' == typeof objects.column)
			if ('undefined' != typeof objects.columns)
				if ('undefined' != typeof objects.columns[position])
					objects.column = position;
		if ('undefined' == typeof objects.column)
			for (var column = 0; 'undefined' == typeof objects.column && column < objects.columns.length; ++column)
				if (objects.columns[column].id == position)
					objects.column = column;
		if ('undefined' == typeof objects.column)
			throw { name: 'TableError', message: 'Invalid column number / row id specified.' }
	}
	gbtx.ext.tables.columns.append = function(column_definition, table) {
		var objects = { source: table }
		gbtx.ext.tables.internal.objectify(objects, ['table', 'header', 'body']);
		var cell = gbtx.ext.tables.internal.createCell(objects, column_definition.id);
		if ('undefined' != typeof column_definition.name)
			cell.innerHTML = column_definition.name;
		objects.header.firstChild.appendChild(cell);
		if ('undefined' != typeof objects.rows)
			for (var i = 0; i < objects.rows.length; ++i)
				gbtx.ext.tables.cells.append({id: null}, objects.rows[i]);
	}
	gbtx.ext.tables.columns.insert = function(column_definition, source, position) {
		var objects = { source: source }
		gbtx.ext.tables.internal.objectify(objects, ['table', 'header']);
		if ('undefined' == typeof objects.column)
			gbtx.ext.tables.columns.internal.calculateColumn(objects, position);
		var column = gbtx.ext.tables.internal.createCell(objects, column_definition.id);
		if ('undefined' != typeof column_definition.name)
			column.innerHTML = column_definition.name;
		objects.header.firstChild.insertBefore(column, objects.columns[objects.column]);
		if ('undefined' != typeof objects.rows)
			for (var i = 0; i < objects.rows.length; ++i)
				gbtx.ext.tables.cells.insert({id: null}, objects.rows[i], objects.column);
	}
	gbtx.ext.tables.columns.replace = function(column_definition, source, position) {
		var objects = { source: source }
		gbtx.ext.tables.internal.objectify(objects, ['table', 'header', 'columns']);
		if ('undefined' == typeof objects.column)
			gbtx.ext.tables.columns.internal.calculateColumn(objects, position);
		var before = objects.columns[objects.column];
		var column = gbtx.ext.tables.internal.createCell(objects, column_definition.id);
		if ('undefined' != typeof column_definition.name)
			column.innerHTML = column_definition.name;
		objects.header.firstChild.insertBefore(column, before);
		objects.header.firstChild.removeChild(before);
		if ('undefined' != typeof objects.rows)
			for (var i = 0; i < objects.rows.length; ++i)
				gbtx.ext.tables.cells.replace({id: null}, objects.rows[i], objects.column);
	}
	gbtx.ext.tables.columns.remove = function(source, position) {
		var objects = { source: source }
		gbtx.ext.tables.internal.objectify(objects, ['table', 'header']);
		if ('undefined' == typeof objects.column)
			gbtx.ext.tables.columns.internal.calculateColumn(objects, position);
		objects.header.firstChild.removeChild(objects.columns[objects.column]);
		if ('undefined' != typeof objects.rows)
			for (var i = 0; i < objects.rows.length; ++i)
				gbtx.ext.tables.cells.remove(objects.rows[i], objects.column);
	}
	gbtx.ext.tables.columns.assign = function(values, source, position, start_row) {
		var objects = { source: source }
		gbtx.ext.tables.internal.objectify(objects, ['table', 'cell']);
		if ('undefined' == typeof objects.column)
			gbtx.ext.tables.columns.internal.calculateColumn(objects, position);
		for (var row = 0; row < values.length; ++row)
			gbtx.ext.tables.cells.assign(values[row], objects.rows[start_row + row], objects.column);
	}
	gbtx.ext.tables.columns.assignProperty = function(value, source, position, property) {
		var objects = { source: source }
		gbtx.ext.tables.internal.objectify(objects, ['table', 'cell']);
		if ('undefined' == typeof objects.column)
			gbtx.ext.tables.columns.internal.calculateColumn(objects, position);
		for (var row = 0; row < objects.rows.length; ++row)
			gbtx.ext.tables.cells.assignProperty(value, objects.rows[row], objects.column, property);
	}
	// cells
	gbtx.ext.tables.cells = {}
	gbtx.ext.tables.cells.internal = {}
	gbtx.ext.tables.cells.internal.calculateCell = function(objects, position) {
		if ('undefined' == typeof position)
			throw { name: 'TableError', message: 'Missing cell number / id.' }
		if ('undefined' == typeof objects.cell)
			if ('undefined' != typeof objects.cells)
				if ('undefined' != typeof objects.cells[position])
					objects.cell = objects.cells[position];
		if ('undefined' == typeof objects.cell)
			if ('undefined' != typeof objects.columns)
				for (var column = 0; 'undefined' == typeof objects.cell && column < objects.columns.length; ++column)
					if (objects.columns[column].id == position)
						objects.cell = objects.cells[column];
		if ('undefined' == typeof objects.cell)
			throw { name: 'TableError', message: 'Invalid cell number / id specified.' }
	}
	gbtx.ext.tables.cells.append = function(cell_definition, source) {
		var objects = { source: source }
		gbtx.ext.tables.internal.objectify(objects, ['table', 'row']);
		var cell = gbtx.ext.tables.internal.createCell(objects, cell_definition.id);
		if ('undefined' != typeof cell_definition.name)
			cell.innerHTML = cell_definition.name;
		objects.row.appendChild(cell);
	}
	gbtx.ext.tables.cells.insert = function(cell_definition, source, position) {
		var objects = { source: source }
		gbtx.ext.tables.internal.objectify(objects, ['table', 'row']);
		if ('undefined' == typeof objects.cell)
			gbtx.ext.tables.cells.internal.calculateCell(objects, position);
		var cell = gbtx.ext.tables.internal.createCell(objects, cell_definition.id);
		if ('undefined' != typeof cell_definition.name)
			cell.innerHTML = cell_definition.name;
		objects.row.insertBefore(cell, objects.cell);
	}
	gbtx.ext.tables.cells.replace = function(cell_definition, source, position) {
		var objects = { source: source }
		gbtx.ext.tables.internal.objectify(objects, ['table', 'row']);
		if ('undefined' == typeof objects.cell)
			gbtx.ext.tables.cells.internal.calculateCell(objects, position);
		var cell = gbtx.ext.tables.internal.createCell(objects, cell_definition.id);
		if ('undefined' != typeof cell_definition.name)
			cell.innerHTML = cell_definition.name;
		objects.row.insertBefore(cell, objects.cell);
		objects.row.removeChild(objects.cell);
	}
	gbtx.ext.tables.cells.remove = function(source, position) {
		var objects = { source: source }
		gbtx.ext.tables.internal.objectify(objects, ['table', 'row']);
		if ('undefined' == typeof objects.cell)
			gbtx.ext.tables.cells.internal.calculateCell(objects, position);
		objects.row.removeChild(objects.cell);
	}
	gbtx.ext.tables.cells.assign = function(value, source, position) {
		var objects = { source: source }
		gbtx.ext.tables.internal.objectify(objects, ['table', 'row']);
		if ('undefined' == typeof objects.cell)
			gbtx.ext.tables.cells.internal.calculateCell(objects, position);
		objects.cell.innerHTML = value;
	}
	gbtx.ext.tables.cells.assignProperty = function(value, source, position, property) {
		var objects = { source: source }
		gbtx.ext.tables.internal.objectify(objects, ['table', 'row']);
		if ('undefined' == typeof objects.cell)
			gbtx.ext.tables.cells.internal.calculateCell(objects, position);
		eval('objects.cell.' + property + ' = value;');
	}

	// command handlers

	// tables
	gbtx.command.handler.register('et_at', function(args) {
		args.fullName = 'ext.tables.append';
		gbtx.ext.tables.append(args.data, args.id);
		return true;
	});
	gbtx.command.handler.register('et_it', function(args) {
		args.fullName = 'ext.tables.insert';
		gbtx.ext.tables.insert(args.data, args.id, args.pos);
		return true;
	});
	gbtx.command.handler.register('et_dt', function(args) {
		args.fullName = 'ext.tables.remove';
		gbtx.ext.tables.remove(args.data);
		return true;
	});
	// rows
	gbtx.command.handler.register('et_ar', function(args) {
		args.fullName = 'ext.tables.rows.append';
		gbtx.ext.tables.rows.append(args.data, args.id);
		return true;
	});
	gbtx.command.handler.register('et_ir', function(args) {
		args.fullName = 'ext.tables.rows.insert';
		gbtx.ext.tables.rows.insert(args.data, args.id, args.pos);
		return true;
	});
	gbtx.command.handler.register('et_rr', function(args) {
		args.fullName = 'ext.tables.rows.replace';
		gbtx.ext.tables.rows.replace(args.data, args.id, args.pos);
		return true;
	});
	gbtx.command.handler.register('et_dr', function(args) {
		args.fullName = 'ext.tables.rows.remove';
		gbtx.ext.tables.rows.remove(args.id, args.pos);
		return true;
	});
	gbtx.command.handler.register('et_asr', function(args) {
		args.fullName = 'ext.tables.rows.assign';
		gbtx.ext.tables.rows.assign(args.data, args.id, args.pos);
		return true;
	});
	gbtx.command.handler.register('et_asrp', function(args) {
		args.fullName = 'ext.tables.rows.assignProperty';
		gbtx.ext.tables.rows.assignProperty(args.data, args.id, args.pos, args.prop);
	});
	// columns
	gbtx.command.handler.register('et_acol', function(args) {
		args.fullName = 'ext.tables.columns.append';
		gbtx.ext.tables.columns.append(args.data, args.id);
		return true;
	});
	gbtx.command.handler.register('et_icol', function(args) {
		args.fullName = 'ext.tables.columns.insert';
		gbtx.ext.tables.columns.insert(args.data, args.id, args.pos);
		return true;
	});
	gbtx.command.handler.register('et_rcol', function(args) {
		args.fullName = 'ext.tables.columns.replace';
		gbtx.ext.tables.columns.replace(args.data, args.id, args.pos);
		return true;
	});
	gbtx.command.handler.register('et_dcol', function(args) {
		args.fullName = 'ext.tables.columns.remove';
		gbtx.ext.tables.columns.remove(args.id, args.pos);
		return true;
	});
	gbtx.command.handler.register('et_ascol', function(args) {
		args.fullName = 'ext.tables.columns.assign';
		gbtx.ext.tables.columns.assign(args.data, args.id, args.pos, args.type);
		return true;
	});
	gbtx.command.handler.register('et_ascolp', function(args) {
		args.fullName = 'ext.tables.columns.assignProperty';
		gbtx.ext.tables.columns.assignProperty(args.data, args.id, args.pos, args.prop);
		return true;
	});
	// cells
	gbtx.command.handler.register('et_ac', function(args) {
		args.fullName = 'ext.tables.cells.append';
		gbtx.ext.tables.cells.append(args.data, args.id);
		return true;
	});
	gbtx.command.handler.register('et_ic', function(args) {
		args.fullName = 'ext.tables.cells.insert';
		gbtx.ext.tables.cells.insert(args.data, args.id, args.pos);
		return true;
	});
	gbtx.command.handler.register('et_rc', function(args) {
		args.fullName = 'ext.tables.cells.replace';
		gbtx.ext.tables.cells.replace(args.data, args.id, args.pos);
	});
	gbtx.command.handler.register('et_dc', function(args) {
		args.fullName = 'ext.tables.cells.remove';
		gbtx.ext.tables.cells.remove(args.id, args.pos);
		return true;
	});
	gbtx.command.handler.register('et_asc', function(args) {
		args.fullName = 'ext.tables.cells.assign';
		gbtx.ext.tables.cells.assign(args.data, args.id, args.pos);
		return true;
	});
	gbtx.command.handler.register('et_ascp', function(args) {
		args.fullName = 'ext.tables.cells.assignProperty';
		gbtx.ext.tables.cells.assignProperty(args.data, args.id, args.pos, args.prop);
		return true;
	});
}

installTableUpdater();
