<?php

if (false == class_exists('gbtxPlugin') || false == class_exists('gbtxPluginManager'))
{
	$sBaseFolder = dirname(dirname(dirname(__FILE__)));
	$sgbtxCore = $sBaseFolder . '/gbtx_core';

	if (false == class_exists('gbtxPlugin'))
		require $sgbtxCore . '/gbtxPlugin.inc.php';
	if (false == class_exists('gbtxPluginManager'))
		require $sgbtxCore . '/gbtxPluginManager.inc.php';
}



class clsSwfUpload extends gbtxResponsePlugin
{


//--------------------------------------------------------------------------------------------------------------------------------
	
	private $sCallName = "SWFUpload";
	private $sDefer;
	private $sJavascriptURI;
	private $bInlineScript;
	
	private $sRequestedFunction = NULL;

	private $sgbtxPrefix = "gbtx_";	
//--------------------------------------------------------------------------------------------------------------------------------

	public function clsSwfUpload() 
	{
		$this->sDefer = ''; 
		$this->sJavascriptURI = '';
		$this->bInlineScript = false;
	}
//--------------------------------------------------------------------------------------------------------------------------------
	
	function getName()
	{
		return get_class($this);
	}
	
//--------------------------------------------------------------------------------------------------------------------------------
	public function configure($sName, $mValue)
	{
		
		
		switch ($sName) 
		{
			case 'scriptDeferral':
							if (true === $mValue || false === $mValue) 
							{
								if ($mValue) $this->sDefer = 'defer ';
								else $this->sDefer = '';
							}
							break;
			
			case 'javascript URI' :
							$this->sJavascriptURI = $mValue;
							break;
			case 'inlineScript':
							if (true === $mValue || false === $mValue)
								$this->bInlineScript = $mValue;
						break;

		}
	}

//--------------------------------------------------------------------------------------------------------------------------------

	
	public function generateClientScript()
	{


		echo "\n<script type='text/javascript' " . $this->sDefer . "charset='UTF-8'>\n";
		echo "/* <![CDATA[ */\n";
		echo "if (undefined == gbtx.ext)	gbtx.ext = {};";
		echo "gbtx.ext.SWFupload = {};";
		echo "gbtx.ext.SWFupload.config = {};";
		echo "gbtx.ext.SWFupload.config.javascript_URI='" . $this->sJavascriptURI . "gbtx_plugins/request/swfupload/'";
		echo "/* ]]> */\n";
		echo "</script>\n";

		if ($this->bInlineScript)
		{
			echo "\n<script type='text/javascript' " . $this->sDefer . "charset='UTF-8'>\n";
			echo "/* <![CDATA[ */\n";

			include(dirname(__FILE__) . 'gbtx_plugins/request/swfupload/swfupload.js');
			include(dirname(__FILE__) . 'gbtx_plugins/request/swfupload/swfupload.queue.js');
			include(dirname(__FILE__) . 'gbtx_plugins/request/swfupload/swfupload.gbtx.js');

			echo "/* ]]> */\n";
			echo "</script>\n";
		} else {
			echo "\n<script type='text/javascript' src='" . $this->sJavascriptURI . "gbtx_plugins/request/swfupload/swfupload.js' " . $this->sDefer . "charset='UTF-8'></script>\n";
			echo "\n<script type='text/javascript' src='" . $this->sJavascriptURI . "gbtx_plugins/request/swfupload/swfupload.queue.js' " . $this->sDefer . "charset='UTF-8'></script>\n";
			echo "\n<script type='text/javascript' src='" . $this->sJavascriptURI . "gbtx_plugins/request/swfupload/swfupload.gbtx.js' " . $this->sDefer . "charset='UTF-8'></script>\n";
	
		}

	}

//--------------------------------------------------------------------------------------------------------------------------------


	function transForm($id, $config,$multi=false) {
		$command = array('n'=>'SWFup_tfo', 't' => $id);
		$this->addCommand($command, array(
																	"config" => $config
																	,"multi" => $multi
																)
											);	
	}

//--------------------------------------------------------------------------------------------------------------------------------

	function transField($id, $config,$multi=false) {
		$command = array('n'=>'SWFup_tfi', 't' => $id);
		$this->addCommand($command, array(
																	"config" => $config
																	,"multi" => $multi
																)
											);	
	}
//--------------------------------------------------------------------------------------------------------------------------------

	function destroyField($id) {
		$command = array('n'=>'SWFup_dfi', 't' => $id);
		$this->addCommand($command, array());	
	}
//--------------------------------------------------------------------------------------------------------------------------------

	function destroyForm($id) {
		$command = array('n'=>'SWFup_dfo', 't' => $id);
		$this->addCommand($command, array());	
	}
//--------------------------------------------------------------------------------------------------------------------------------


	
} 


$objPluginManager =& gbtxPluginManager::getInstance();
$objPluginManager->registerPlugin(new clsSwfUpload(), 100);