try {
    if ('undefined' == typeof gbtx)
        throw{name: 'SequenceError', message: 'Error: gbtx core was not detected, debug module disabled.'}
    if ('undefined' == typeof gbtx.debug)
        gbtx.debug = {}
    gbtx.debug.workId = 'gbtxWork' + new Date().getTime();
    gbtx.debug.windowSource = 'about:blank';
    gbtx.debug.windowID = 'gbtx_debug_' + gbtx.debug.workId;
    if ('undefined' == typeof gbtx.debug.windowStyle)
        gbtx.debug.windowStyle = 'width=800,' + 'height=500,' + 'scrollbars=yes,' + 'resizable=yes,' + 'status=yes';
    if ('undefined' == typeof gbtx.debug.windowTemplate)
        gbtx.debug.windowTemplate = '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">' + '<html><head>' + '<title>gbtx debug output</title>' + '<style type="text/css">' + '/* <![CDATA[ */' + '.debugEntry { margin: 3px; padding: 3px; border-top: 1px solid #999999; } ' + '.debugDate { font-weight: bold; margin: 2px; } ' + '.debugText { margin: 2px; } ' + '.warningText { margin: 2px; font-weight: bold; } ' + '.errorText { margin: 2px; font-weight: bold; color: #ff7777; }' + '/* ]]> */' + '</style>' + '</head><body>' + '<h2>gbtx debug output</h2>' + '<div id="debugTag"></div>' + '</body></html>';
    gbtx.debug.text = [];
    gbtx.debug.text[100] = 'WARNING: ';
    gbtx.debug.text[101] = 'ERROR: ';
    gbtx.debug.text[102] = 'gbtx DEBUG MESSAGE:\n';
    gbtx.debug.text[103] = '...\n[LONG RESPONSE]\n...';
    gbtx.debug.text[104] = 'SENDING REQUEST';
    gbtx.debug.text[105] = 'SENT [';
    gbtx.debug.text[106] = ' bytes]';
    gbtx.debug.text[107] = 'CALLING: ';
    gbtx.debug.text[108] = 'URI: ';
    gbtx.debug.text[109] = 'INITIALIZING REQUEST';
    gbtx.debug.text[110] = 'PROCESSING PARAMETERS [';
    gbtx.debug.text[111] = ']';
    gbtx.debug.text[112] = 'NO PARAMETERS TO PROCESS';
    gbtx.debug.text[113] = 'PREPARING REQUEST';
    gbtx.debug.text[114] = 'STARTING gbtx CALL (deprecated: use gbtx.request instead)';
    gbtx.debug.text[115] = 'STARTING gbtx REQUEST';
    gbtx.debug.text[116] = 'No response processor is available to process the response from the server.\n';
    gbtx.debug.text[117] = '.\nCheck for error messages from the server.';
    gbtx.debug.text[118] = 'RECEIVED [status: ';
    gbtx.debug.text[119] = ', size: ';
    gbtx.debug.text[120] = ' bytes, time: ';
    gbtx.debug.text[121] = 'ms]:\n';
    gbtx.debug.text[122] = 'The server returned the following HTTP status: ';
    gbtx.debug.text[123] = '\nRECEIVED:\n';
    gbtx.debug.text[124] = 'The server returned a redirect to:<br />';
    gbtx.debug.text[125] = 'DONE [';
    gbtx.debug.text[126] = 'ms]';
    gbtx.debug.text[127] = 'INITIALIZING REQUEST OBJECT';
    gbtx.debug.exceptions = [];
    gbtx.debug.exceptions[10001] = 'Invalid response XML: The response contains an unknown tag: {data}.';
    gbtx.debug.exceptions[10002] = 'GetRequestObject: XMLHttpRequest is not available, gbtx is disabled.';
    gbtx.debug.exceptions[10003] = 'Queue overflow: Cannot push object onto queue because it is full.';
    gbtx.debug.exceptions[10004] = 'Invalid response XML: The response contains an unexpected tag or text: {data}.';
    gbtx.debug.exceptions[10005] = 'Invalid request URI: Invalid or missing URI; autodetection failed; please specify a one explicitly.';
    gbtx.debug.exceptions[10006] = 'Invalid response command: Malformed response command received.';
    gbtx.debug.exceptions[10007] = 'Invalid response command: Command [{data}] is not a known command.';
    gbtx.debug.exceptions[10008] = 'Element with ID [{data}] not found in the document.';
    gbtx.debug.exceptions[10009] = 'Invalid request: Missing function name parameter.';
    gbtx.debug.exceptions[10010] = 'Invalid request: Missing function object parameter.';
    gbtx.debug.getExceptionText = function (e) {
        if ('undefined' != typeof e.code) {
            if ('undefined' != typeof gbtx.debug.exceptions[e.code]) {
                var msg = gbtx.debug.exceptions[e.code];
                if ('undefined' != typeof e.data) {
                    msg.replace('{data}', e.data);
                }
                return msg;
            }
        } else if ('undefined' != typeof e.name) {
            var msg = e.name;
            if ('undefined' != typeof e.message) {
                msg += ': ';
                msg += e.message;
            }
            return msg;
        }
        return 'An unknown error has occurred.';
    }
    gbtx.debug.writeMessage = function (text, prefix, cls) {
        try {
        } catch (e) {
            if (text.length > 1000)text = text.substr(0, 1000) + gbtx.debug.text[102];
            alert(gbtx.debug.text[102] + text);
        }
    }
    gbtx.debug.prepareDebugText = function (text) {
        try {
            text = text.replace(/&/g, '&amp;').replace(/</g, '&lt;').replace(/>/g, '&gt;').replace(/\n/g, '<br />');
            return text;
        } catch (e) {
            gbtx.debug.stringReplace = function (haystack, needle, newNeedle) {
                var segments = haystack.split(needle);
                haystack = '';
                for (var i = 0; i < segments.length; ++i) {
                    if (0 != i)
                        haystack += newNeedle;
                    haystack += segments[i];
                }
                return haystack;
            }
            gbtx.debug.prepareDebugText = function (text) {
                text = gbtx.debug.stringReplace(text, '&', '&amp;');
                text = gbtx.debug.stringReplace(text, '<', '&lt;');
                text = gbtx.debug.stringReplace(text, '>', '&gt;');
                text = gbtx.debug.stringReplace(text, '\n', '<br />');
                return text;
            }
            gbtx.debug.prepareDebugText(text);
        }
    }
    gbtx.debug.executeCommand = gbtx.executeCommand;
    gbtx.executeCommand = function (args) {
        try {
            if ('undefined' == typeof args.cmd)
                throw{code: 10006};
            if (false == gbtx.command.handler.isRegistered(args))
                throw{code: 10007, data: args.cmd};
            return gbtx.debug.executeCommand(args);
        } catch (e) {
            var msg = 'ExecuteCommand (';
            if ('undefined' != typeof args.sequence) {
                msg += '#';
                msg += args.sequence;
                msg += ', ';
            }
            if ('undefined' != typeof args.cmdFullName) {
                msg += '"';
                msg += args.cmdFullName;
                msg += '"';
            }
            msg += '):\n';
            msg += gbtx.debug.getExceptionText(e);
            msg += '\n';
            gbtx.debug.writeMessage(msg, gbtx.debug.text[101], 'errorText');
        }
        return true;
    }
    gbtx.debug.parseAttributes = gbtx.parseAttributes;
    gbtx.parseAttributes = function (child, obj) {
        try {
            gbtx.debug.parseAttributes(child, obj);
        } catch (e) {
            var msg = 'ParseAttributes:\n';
            msg += gbtx.debug.getExceptionText(e);
            msg += '\n';
            gbtx.debug.writeMessage(msg, gbtx.debug.text[101], 'errorText');
        }
    }
    gbtx.debug.commandHandler = gbtx.command.handler.unregister('dbg');
    gbtx.command.handler.register('dbg', function (args) {
        args.cmdFullName = 'debug message';
        gbtx.debug.writeMessage(args.data, gbtx.debug.text[100], 'warningText');
        return gbtx.debug.commandHandler(args);
    });
    gbtx.debug.$ = gbtx.tools.$;
    gbtx.tools.$ = function (sId) {
        try {
            var returnValue = gbtx.debug.$(sId);
            if ('object' != typeof returnValue)
                throw{code: 10008};
        }
        catch (e) {
            var msg = '$:';
            msg += gbtx.debug.getExceptionText(e);
            msg += '\n';
            gbtx.debug.writeMessage(msg, gbtx.debug.text[100], 'warningText');
        }
        return returnValue;
    }
    gbtx.debug._objectToXML = gbtx.tools._objectToXML;
    gbtx.tools._objectToXML = function (obj, guard) {
        try {
            if (0 == guard.size) {
                var msg = 'OBJECT TO XML: maxDepth = ';
                msg += guard.maxDepth;
                msg += ', maxSize = ';
                msg += guard.maxSize;
                gbtx.debug.writeMessage(msg);
            }
            var r = gbtx.debug._objectToXML(obj, guard);
            if (0 == guard.depth) {
                var msg = 'OBJECT TO XML: size = ';
                msg += guard.size;
                gbtx.debug.writeMessage(msg);
            }
            return r;
        } catch (e) {
            var msg = 'ObjectToXML: ';
            msg += gbtx.debug.getExceptionText(e);
            msg += '\n';
            gbtx.debug.writeMessage(msg, gbtx.debug.text[101], 'errorText');
        }
        return '';
    }
    gbtx.debug._internalSend = gbtx._internalSend;
    gbtx._internalSend = function (oRequest) {
        try {
            gbtx.debug.writeMessage(gbtx.debug.text[104]);
            gbtx.debug.writeMessage(gbtx.debug.text[105] +
                oRequest.requestData.length +
                gbtx.debug.text[106]);
            oRequest.beginDate = new Date();
            gbtx.debug._internalSend(oRequest);
        } catch (e) {
            var msg = 'InternalSend: ';
            msg += gbtx.debug.getExceptionText(e);
            msg += '\n';
            gbtx.debug.writeMessage(msg, gbtx.debug.text[101], 'errorText');
            throw e;
        }
    }
    gbtx.debug.submitRequest = gbtx.submitRequest;
    gbtx.submitRequest = function (oRequest) {
        var msg = oRequest.requestData;
        msg += ': ';
        text = decodeURIComponent(oRequest.requestData);
        text = text.replace(new RegExp('&xjx', 'g'), '\n&xjx');
        text = text.replace(new RegExp('<xjxobj>', 'g'), '\n<xjxobj>');
        text = text.replace(new RegExp('<e>', 'g'), '\n<e>');
        text = text.replace(new RegExp('</xjxobj>', 'g'), '\n</xjxobj>\n');
        msg += text;
        gbtx.debug.writeMessage(msg);
        msg = gbtx.debug.text[107];
        var separator = '\n';
        for (var mbr in oRequest.functionName) {
            msg += separator;
            msg += mbr;
            msg += ': ';
            msg += oRequest.functionName[mbr];
            separator = '\n';
        }
        msg += separator;
        msg += gbtx.debug.text[108];
        msg += separator;
        msg += oRequest.URI;
        gbtx.debug.writeMessage(msg);
        try {
            return gbtx.debug.submitRequest(oRequest);
        } catch (e) {
            gbtx.debug.writeMessage(e.message);
            if (0 < oRequest.retry)
                throw e;
        }
    }
    gbtx.debug.initializeRequest = gbtx.initializeRequest;
    gbtx.initializeRequest = function (oRequest) {
        try {
            var msg = gbtx.debug.text[109];
            gbtx.debug.writeMessage(msg);
            return gbtx.debug.initializeRequest(oRequest);
        } catch (e) {
            var msg = 'InitializeRequest: ';
            msg += gbtx.debug.getExceptionText(e);
            msg += '\n';
            gbtx.debug.writeMessage(msg, gbtx.debug.text[101], 'errorText');
            throw e;
        }
    }
    gbtx.debug.processParameters = gbtx.processParameters;
    gbtx.processParameters = function (oRequest) {
        try {
            if ('undefined' != typeof oRequest.parameters) {
                var msg = gbtx.debug.text[110];
                msg += oRequest.parameters.length;
                msg += gbtx.debug.text[111];
                gbtx.debug.writeMessage(msg);
            } else {
                var msg = gbtx.debug.text[112];
                gbtx.debug.writeMessage(msg);
            }
            return gbtx.debug.processParameters(oRequest);
        } catch (e) {
            var msg = 'ProcessParameters: ';
            msg += gbtx.debug.getExceptionText(e);
            msg += '\n';
            gbtx.debug.writeMessage(msg, gbtx.debug.text[101], 'errorText');
            throw e;
        }
    }
    gbtx.debug.prepareRequest = gbtx.prepareRequest;
    gbtx.prepareRequest = function (oRequest) {
        try {
            var msg = gbtx.debug.text[113];
            gbtx.debug.writeMessage(msg);
            return gbtx.debug.prepareRequest(oRequest);
        } catch (e) {
            var msg = 'PrepareRequest: ';
            msg += gbtx.debug.getExceptionText(e);
            msg += '\n';
            gbtx.debug.writeMessage(msg, gbtx.debug.text[101], 'errorText');
            throw e;
        }
    }
    gbtx.debug.call = gbtx.call;
    gbtx.call = function () {
        try {
            gbtx.debug.writeMessage(gbtx.debug.text[114]);
            var numArgs = arguments.length;
            if (0 == numArgs)
                throw{code: 10009};
            var functionName = arguments[0];
            var oOptions = {}
            if (1 < numArgs)
                oOptions = arguments[1];
            oOptions.debugging = true;
            return gbtx.debug.call(functionName, oOptions);
        } catch (e) {
            var msg = 'Call: ';
            msg += gbtx.debug.getExceptionText(e);
            msg += '\n';
            gbtx.debug.writeMessage(msg, gbtx.debug.text[101], 'errorText');
            throw e;
        }
    }
    gbtx.debug.request = gbtx.request;
    gbtx.request = function () {
        try {
            gbtx.debug.writeMessage(gbtx.debug.text[115]);
            var numArgs = arguments.length;
            if (0 == numArgs)
                throw{code: 10010};
            var oFunction = arguments[0];
            var oOptions = {}
            if (1 < numArgs)
                oOptions = arguments[1];
            oOptions.debugging = true;
            return gbtx.debug.request(oFunction, oOptions);
        } catch (e) {
            var msg = 'Request: ';
            msg += gbtx.debug.getExceptionText(e);
            msg += '\n';
            gbtx.debug.writeMessage(msg, gbtx.debug.text[101], 'errorText');
            throw e;
        }
    }
    gbtx.debug.getResponseProcessor = gbtx.getResponseProcessor;
    gbtx.getResponseProcessor = function (oRequest) {
        try {
            var fProc = gbtx.debug.getResponseProcessor(oRequest);
            if ('undefined' == typeof fProc) {
                var msg = gbtx.debug.text[116];
                try {
                    var contentType = oRequest.request.getResponseHeader('content-type');
                    msg += "Content-Type: ";
                    msg += contentType;
                    if ('text/html' == contentType) {
                        msg += gbtx.debug.text[117];
                    }
                } catch (e) {
                }
                gbtx.debug.writeMessage(msg, gbtx.debug.text[101], 'errorText');
            }
            return fProc;
        } catch (e) {
            var msg = 'GetResponseProcessor: ';
            msg += gbtx.debug.getExceptionText(e);
            msg += '\n';
            gbtx.debug.writeMessage(msg, gbtx.debug.text[101], 'errorText');
            throw e;
        }
    }
    gbtx.debug.responseReceived = gbtx.responseReceived;
    gbtx.responseReceived = function (oRequest) {
        var xx = gbtx;
        var xt = xx.tools;
        var xd = xx.debug;
        var oRet;
        try {
            var status = oRequest.request.status;
            if (xt.arrayContainsValue(xx.responseSuccessCodes, status)) {
                var packet = oRequest.request.responseText;
                packet = packet.replace(new RegExp('<cmd', 'g'), '\n<cmd');
                packet = packet.replace(new RegExp('<xjx>', 'g'), '\n<xjx>');
                packet = packet.replace(new RegExp('<xjxobj>', 'g'), '\n<xjxobj>');
                packet = packet.replace(new RegExp('<e>', 'g'), '\n<e>');
                packet = packet.replace(new RegExp('</xjxobj>', 'g'), '\n</xjxobj>\n');
                packet = packet.replace(new RegExp('</xjx>', 'g'), '\n</xjx>');

                if (oRequest.request.responseText.substr(0, 5) != "<?xml" && oRequest.request.responseText.trim().length > 1 ) {
                    alert(packet);
                    return;

                }
                

                oRequest.midDate = new Date();
                var msg = gbtx.debug.text[118];
                msg += oRequest.request.status;
                msg += gbtx.debug.text[119];
                msg += packet.length;
                msg += gbtx.debug.text[120];
                msg += (oRequest.midDate - oRequest.beginDate);
                msg += gbtx.debug.text[121];
                msg += packet;
                xd.writeMessage(msg);
            }
            else if (xt.arrayContainsValue(xx.responseErrorsForAlert, status)) {
                var msg = gbtx.debug.text[122];
                msg += status;
                msg += gbtx.debug.text[123];
                msg += oRequest.request.responseText;
                xd.writeMessage(msg, gbtx.debug.text[101], 'errorText');
            }
            else if (xt.arrayContainsValue(xx.responseRedirectCodes, status)) {
                var msg = gbtx.debug.text[124];
                msg += oRequest.request.getResponseHeader('location');
                xd.writeMessage(msg);
            }
            oRet = xd.responseReceived(oRequest);
        }
        catch (e) {
            var msg = 'ResponseReceived: ';
            msg += gbtx.debug.getExceptionText(e);
            msg += '\n';
            xd.writeMessage(msg, gbtx.debug.text[101], 'errorText');
            oRequest.midDate = new Date();
            var msg = "Hata Olustu \n"
            msg += gbtx.debug.text[118];
            msg += oRequest.request.status;
            msg += gbtx.debug.text[119];
            msg += packet.length;
            msg += gbtx.debug.text[120];
            msg += (oRequest.midDate - oRequest.beginDate);
            msg += gbtx.debug.text[121];
            msg += packet;
            $("#popup_baslik").html('Hata Olustu');
            $("#popup_icerik").html('<pre><textarea style="background-color: rgba(248, 255, 76, 0.29); border:4px solid #ee911b;width:99%;height:350px;">' + msg.replace(new RegExp("textarea", 'g'), '') + "<br>-_-_-_-_-_-_<br>" + packet.replace(new RegExp("textarea", 'g'), '') + '</textarea></pre>');
            PopupYukle(1000, 'error', 1, 'Hata Olustu');
        }
        return oRet;
    }
    gbtx.debug.completeResponse = gbtx.completeResponse;
    gbtx.completeResponse = function (oRequest) {
        try {
            var returnValue = gbtx.debug.completeResponse(oRequest);
            oRequest.endDate = new Date();
            var msg = gbtx.debug.text[125];
            msg += (oRequest.endDate - oRequest.beginDate);
            msg += gbtx.debug.text[126];
            gbtx.debug.writeMessage(msg);
            return returnValue;
        } catch (e) {
            var msg = 'CompleteResponse: ';
            msg += gbtx.debug.getExceptionText(e);
            msg += '\n';
            gbtx.debug.writeMessage(msg, gbtx.debug.text[101], 'errorText');
            throw e;
        }
    }
    gbtx.debug.getRequestObject = gbtx.tools.getRequestObject;
    gbtx.tools.getRequestObject = function () {
        try {
            gbtx.debug.writeMessage(gbtx.debug.text[127]);
            return gbtx.debug.getRequestObject();
        } catch (e) {
            var msg = 'GetRequestObject: ';
            msg += gbtx.debug.getExceptionText(e);
            msg += '\n';
            gbtx.debug.writeMessage(msg, gbtx.debug.text[101], 'errorText');
            throw e;
        }
    }
    if (gbtx.dom.assign) {
        gbtx.debug.assign = gbtx.dom.assign;
        gbtx.dom.assign = function (element, property, data) {
            try {
                return gbtx.debug.assign(element, property, data);
            } catch (e) {
                var msg = 'gbtx.dom.assign: ';
                msg += gbtx.debug.getExceptionText(e);
                msg += '\n';
                msg += 'Eval: element.';
                msg += property;
                msg += ' = data;\n';
                gbtx.debug.writeMessage(msg, gbtx.debug.text[101], 'errorText');
            }
            return true;
        }
    }
    if (gbtx.tools) {
        if (gbtx.tools.queue) {
            if (gbtx.tools.queue.retry) {
                if ('undefined' == typeof gbtx.debug.tools)
                    gbtx.debug.tools = {};
                if ('undefined' == typeof gbtx.debug.tools.queue)
                    gbtx.debug.tools.queue = {};
                gbtx.debug.tools.queue.retry = gbtx.tools.queue.retry;
                gbtx.tools.queue.retry = function (obj, count) {
                    if (gbtx.debug.tools.queue.retry(obj, count))
                        return true;
                    if (obj.cmd && 's' == obj.cmd)
                        return false;
                    gbtx.debug.writeMessage('Retry count exceeded.');
                    return false;
                }
            }
        }
    }
    gbtx.debug.isLoaded = true;
    xjx = {}
    xjx.$ = gbtx.tools.$;
    xjx.getFormValues = gbtx.tools.getFormValues;
    xjx.call = gbtx.call;
    xjx.request = gbtx.request;
    gbtx.$ = gbtx.tools.$;
    gbtx.getFormValues = gbtx.tools.getFormValues;
} catch (e) {
    alert(e.name + ': ' + e.message);
}