<?php
/*
	File: gbtxPlugin.inc.php

	Contains the gbtxPlugin class

	Title: gbtxPlugin class

	Please see <copyright.inc.php> for a detailed description, copyright
	and license information.
*/

/*
	@package gbtx
	@version $Id: gbtxPlugin.inc.php 362 2007-05-29 15:32:24Z calltoconstruct $
	@copyright Copyright (c) 2005-2006 by Jared White & J. Max Wilson
	@license http://www.gbtxproject.org/bsd_license.txt BSD License
*/

/*
	Class: gbtxPlugin
	
	The base class for all gbtx plugins.
*/
class gbtxPlugin
{
}

/*
	Class: gbtxRequestPlugin
	
	The base class for all gbtx request plugins.
	
	Request plugins handle the registration, client script generation and processing of
	gbtx enabled requests.  Each plugin should have a unique signature for both
	the registration and processing of requests.  During registration, the user will
	specify a type which will allow the plugin to detect and handle it.  During client
	script generation, the plugin will generate a <gbtx.request> stub with the
	prescribed call options and request signature.  During request processing, the
	plugin will detect the signature generated previously and process the request
	accordingly.
*/
class gbtxRequestPlugin extends gbtxPlugin
{
	/*
		Function: configure
		
		Called by the <gbtxPluginManager> when a configuration setting is changing.
		Plugins should store a local copy of the settings they wish to use during 
		registration, client script generation or request processing.
	*/
	function configure($sName, $mValue)
	{
	}
	
	/*
		Function: register
		
		Called by the <gbtxPluginManager> when a user script when a function, event 
		or callable object is to be registered.  Additional plugins may support other 
		registration types.
	*/
	function register($aArgs)
	{
		return false;
	}
	
	/*
		Function: generateClientScript
		
		Called by <gbtxPluginManager> when the page's HTML is being sent to the browser.
		This allows each plugin to inject some script / style or other appropriate tags
		into the HEAD of the document.  Each block must be appropriately enclosed, meaning
		javascript code must be enclosed in SCRIPT and /SCRIPT tags.
	*/
	function generateClientScript()
	{
	}
	
	/*
		Function: canProcessRequest
		
		Called by the <gbtxPluginManager> when a request has been received to determine
		if the request is for a gbtx enabled function or for the initial page load.
	*/
	function canProcessRequest()
	{
		return false;
	}
	
	/*
		Function: processRequest
		
		Called by the <gbtxPluginManager> when a request is being processed.  This 
		will only occur when <gbtx> has determined that the current request is a valid
		(registered) gbtx enabled function via <gbtx->canProcessRequest>.
	*/
	function processRequest()
	{
		return false;
	}
}

/*
	Class: gbtxResponsePlugin
	
	Base class for all gbtx response plugins.
	
	A response plugin provides additional services not already provided by the 
	<gbtxResponse> class with regard to sending response commands to the
	client.  In addition, a response command may send javascript to the browser
	at page load to aid in the processing of it's response commands.
*/
class gbtxResponsePlugin extends gbtxPlugin
{
	/*
		Object: objResponse
		
		A reference to the current <gbtxResponse> object that is being used
		to build the response that will be sent to the client browser.
	*/
	var $objResponse;
	
	/*
		Function: setResponse
		
		Called by the <gbtxResponse> object that is currently being used
		to build the response that will be sent to the client browser.
		
		objResponse - (object):  A reference to the <gbtxResponse> object
	*/
	function setResponse(&$objResponse)
	{
		$this->objResponse =& $objResponse;
	}
	
	/*
		Function: addCommand
		
		Used internally to add a command to the response command list.  This
		will call <gbtxResponse->addPluginCommand> using the reference provided
		in <gbtxResponsePlugin->setResponse>.
	*/
 	function addCommand($aAttributes, $sData)
 	{
 		$this->objResponse->addPluginCommand($this, $aAttributes, $sData);
 	}
	
	/*
		Function: getName
		
		Called by the <gbtxPluginManager> when the user script requests a plugin.
		This name must match the plugin name requested in the called to 
		<gbtxResponse->plugin>.
	*/
	function getName()
	{
//SkipDebug
		$objLanguageManager =& gbtxLanguageManager::getInstance();
		trigger_error(
			$objLanguageManager->getText('XJXPLG:GNERR:01')
			, E_USER_ERROR
			);
//EndSkipDebug
	}
	
	/*
		Function: process
		
		Called by <gbtxResponse> when a user script requests the service of a
		response plugin.  The parameters provided by the user will be used to
		determine which response command and parameters will be sent to the
		client upon completion of the gbtx request process.
	*/
	function process()
	{
//SkipDebug
		$objLanguageManager =& gbtxLanguageManager::getInstance();
		trigger_error(
			$objLanguageManager->getText('XJXPLG:PERR:01')
			, E_USER_ERROR
			);
//EndSkipDebug
	}
}
