

<script type="text/javascript">
    $(function () {

        $('#uye_genel').highcharts({
            chart: {
                type: 'area',
                backgroundColor:'#F8F8F8 ',
                height:400

            },
            title: {
                text: 'AYLARA GÖRE ÜYE DAĞILIMI'
            },

            xAxis: {
                categories: [{aylar}],
                crosshair: true
            },
            yAxis: {
                min: 0,
                title: {
                    text: 'ADET'
                }
            },
            tooltip: {
                headerFormat: '<span style="font-size:10px">{point.key}</span><table>',
                pointFormat: '<tr><td style="color:{series.color};padding:0">{series.name}: </td>' +
                        '<td style="padding:0"><b>{point.y} ADET</b></td></tr>',
                footerFormat: '</table>',
                shared: true,
                useHTML: true
            },
            plotOptions: {
                column: {
                    pointPadding: 0.2,
                    borderWidth: 0
                }
            },
            series: [{
                name: 'TOPLAM',
                data: [{toplam}]

            }
            ]
        });

        $('#uye_il').highcharts({
            chart: {
                type: 'column',
                backgroundColor:'#F8F8F8 ',
                height:400

            },
            title: {
                text: 'İLLERE  GÖRE ÜYE DAĞILIMI'
            },

            xAxis: {
                categories: [{iller}],
                crosshair: true
            },
            yAxis: {
                min: 0,
                title: {
                    text: 'ADET'
                }
            },
            plotOptions: {
                series: {
                    borderWidth: 0,
                    dataLabels: {
                        enabled: true,
                        format: '{point.key}'
                    }
                },
                column: {
                    pointPadding: 0.2,
                    borderWidth: 0
                }
            },

            tooltip: {
                headerFormat: '<span style="font-size:10px">{point.key}</span><table>',
                pointFormat: '<tr><td style="color:{series.color};padding:0">{series.name}: </td>' +
                        '<td style="padding:0"><b>{point.y} ADET</b></td>'+
                        '<td style="padding:0"><b>{point.percentage:.1f} % </b></td>'+
                        '</tr>',
                footerFormat: '</table>',
                shared: true,
                useHTML: true
            },

            series: [{
                name: 'TOPLAM',
                data: [{il_toplam}],

                dataLabels: {
                    enabled: true,
                    rotation: 0,

                    align: 'right',
                    format: '{point.y:.0f}', // one decimal
                    y: 0, // 10 pixels down from the top
                    style: {
                    fontSize: '11px',
                        fontFamily: 'Verdana, sans-serif'
                    }
                }

            }]
        });
    });


</script>

<div class="clearfix">
    <div id="uye_genel"></div>
</div>
<div class="clearfix">
    <div id="uye_il"></div>
</div>

