

<script type="text/javascript">
    $(function () {
        $('#siparis_adet').highcharts({
            chart: {
                height:400,
                backgroundColor:'#F8F8F8 ',
                type: 'pie',
                options3d: {
                    enabled: true,
                    alpha: 45,
                    beta: 0
                }
            },
            title: {
                text: 'SİPARİŞ DURUMUNA GÖRE ADETLER'
            },
            tooltip: {
                pointFormat: '{series.name}: <b>{point.y} Adet</b> ({point.percentage:.1f} %) '
            },
            plotOptions: {
                pie: {
                    allowPointSelect: true,
                    cursor: 'pointer',
                    depth: 35,
                    dataLabels: {
                        enabled: true,
                        format: '{point.name}'
                    }
                }
            },
            series: [{
                type: 'pie',
                name: 'Toplam',
                data: {data_adet}
            }]
        });

        $('#siparis_tutar').highcharts({
            chart: {
                height:400,
                backgroundColor:'#F8F8F8 ',
                type: 'pie',
                options3d: {
                    enabled: true,
                    alpha: 45,
                    beta: 0
                }
            },
            title: {
                text: 'SİPARİŞ DURUMUNA GÖRE TUTARLAR'
            },
            tooltip: {
                pointFormat: '{series.name}: <b>{point.y:.1f} TL ({point.percentage:.1f} %)'
            },
            plotOptions: {
                pie: {
                    allowPointSelect: true,
                    cursor: 'pointer',
                    depth: 35,
                    dataLabels: {
                        enabled: true,
                        format: '{point.name}'
                    }
                }
            },
            series: [{
                type: 'pie',
                name: 'Toplam',
                data: {data_tutar}
            }]
        });

        $('#siparis_genel').highcharts({
            chart: {
                height: 300,
                backgroundColor:'#F8F8F8 '

            },
            title: {
                text: 'AYLARA GÖRE SİPARİŞ/FATURA/İADE DURUMLARI'
            },

            xAxis: {
                categories: [{aylar}],
                crosshair: true
            },
            yAxis: {
                min: 0,
                title: {
                    text: 'Tutar'
                }
            },
            tooltip: {
                headerFormat: '<span style="font-size:10px">{point.key}</span><table>',
                pointFormat: '<tr><td style="color:{series.color};padding:0">{series.name}: </td>' +
                        '<td style="padding:0"><b>{point.y:.1f} TL</b></td></tr>',
                footerFormat: '</table>',
                shared: true,
                useHTML: true
            },
            plotOptions: {
                column: {
                    pointPadding: 0.2,
                    borderWidth: 0
                }
            },
            series: [
                {
                    name: 'SİPARİŞ',
                    data: [{siparis}]

                }, {
                    name: 'FATURA',
                    data: [{fatura}]

                }, {
                    name: 'İADE',
                    data: [{iade}]

                }
            ]
        });

    });


</script>

<div class="clearfix">
    <div class="fl" style="width: 49%;" id="siparis_adet"></div>
    <div class="fr" style="width: 49%;" id="siparis_tutar"></div>
</div>
<div class="clearfix">
    <div id="siparis_genel"></div>
</div>

