<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=2">
    <title>elFinder 2.1.x source version with PHP connector</title>

    <!-- Section CSS -->
    <!-- jQuery UI (REQUIRED) -->
    <link rel="stylesheet" href="jquery/jquery-ui-1.12.0.css" type="text/css">

    <!-- elfinder css -->
    <link rel="stylesheet" href="css/commands.css" type="text/css">
    <link rel="stylesheet" href="css/common.css" type="text/css">
    <link rel="stylesheet" href="css/contextmenu.css" type="text/css">
    <link rel="stylesheet" href="css/cwd.css" type="text/css">
    <link rel="stylesheet" href="css/dialog.css" type="text/css">
    <link rel="stylesheet" href="css/fonts.css" type="text/css">
    <link rel="stylesheet" href="css/navbar.css" type="text/css">
    <link rel="stylesheet" href="css/places.css" type="text/css">
    <link rel="stylesheet" href="css/quicklook.css" type="text/css">
    <link rel="stylesheet" href="css/statusbar.css" type="text/css">
    <link rel="stylesheet" href="css/theme.css" type="text/css">
    <link rel="stylesheet" href="css/toast.css" type="text/css">
    <link rel="stylesheet" href="css/toolbar.css" type="text/css">

    <!-- Section JavaScript -->
    <!-- jQuery and jQuery UI (REQUIRED) -->
    <script src="jquery/jquery-1.12.4.js" type="text/javascript" charset="utf-8"></script>
    <script src="jquery/jquery-ui-1.12.0.js" type="text/javascript" charset="utf-8"></script>

    <!-- elfinder core -->
    <script src="js/elFinder.js"></script>
    <script src="js/elFinder.version.js"></script>
    <script src="js/jquery.elfinder.js"></script>
    <script src="js/elFinder.mimetypes.js"></script>
    <script src="js/elFinder.options.js"></script>
    <script src="js/elFinder.options.netmount.js"></script>
    <script src="js/elFinder.history.js"></script>
    <script src="js/elFinder.command.js"></script>
    <script src="js/elFinder.resources.js"></script>

    <!-- elfinder dialog -->
    <script src="js/jquery.dialogelfinder.js"></script>

    <!-- elfinder default lang -->
    <script src="js/i18n/elfinder.tr.js"></script>

    <!-- elfinder ui -->
    <script src="js/ui/button.js"></script>
    <script src="js/ui/contextmenu.js"></script>
    <script src="js/ui/cwd.js"></script>
    <script src="js/ui/dialog.js"></script>
    <script src="js/ui/fullscreenbutton.js"></script>
    <script src="js/ui/navbar.js"></script>
    <script src="js/ui/navdock.js"></script>
    <script src="js/ui/overlay.js"></script>
    <script src="js/ui/panel.js"></script>
    <script src="js/ui/path.js"></script>
    <script src="js/ui/places.js"></script>
    <script src="js/ui/searchbutton.js"></script>
    <script src="js/ui/sortbutton.js"></script>
    <script src="js/ui/stat.js"></script>
    <script src="js/ui/toast.js"></script>
    <script src="js/ui/toolbar.js"></script>
    <script src="js/ui/tree.js"></script>
    <script src="js/ui/uploadButton.js"></script>
    <script src="js/ui/viewbutton.js"></script>
    <script src="js/ui/workzone.js"></script>

    <!-- elfinder commands -->
    <script src="js/commands/archive.js"></script>
    <script src="js/commands/back.js"></script>
    <script src="js/commands/chmod.js"></script>
    <script src="js/commands/colwidth.js"></script>
    <script src="js/commands/copy.js"></script>
    <script src="js/commands/cut.js"></script>
    <script src="js/commands/download.js"></script>
    <script src="js/commands/duplicate.js"></script>
    <script src="js/commands/edit.js"></script>
    <script src="js/commands/empty.js"></script>
    <script src="js/commands/extract.js"></script>
    <script src="js/commands/forward.js"></script>
    <script src="js/commands/fullscreen.js"></script>
    <script src="js/commands/getfile.js"></script>
    <script src="js/commands/help.js"></script>
    <script src="js/commands/hidden.js"></script>
    <script src="js/commands/hide.js"></script>
    <script src="js/commands/home.js"></script>
    <script src="js/commands/info.js"></script>
    <script src="js/commands/mkdir.js"></script>
    <script src="js/commands/mkfile.js"></script>
    <script src="js/commands/netmount.js"></script>
    <script src="js/commands/open.js"></script>
    <script src="js/commands/opendir.js"></script>
    <script src="js/commands/opennew.js"></script>
    <script src="js/commands/paste.js"></script>
    <script src="js/commands/places.js"></script>
    <script src="js/commands/preference.js"></script>
    <script src="js/commands/quicklook.js"></script>
    <script src="js/commands/quicklook.plugins.js"></script>
    <script src="js/commands/reload.js"></script>
    <script src="js/commands/rename.js"></script>
    <script src="js/commands/resize.js"></script>
    <script src="js/commands/restore.js"></script>
    <script src="js/commands/rm.js"></script>
    <script src="js/commands/search.js"></script>
    <script src="js/commands/selectall.js"></script>
    <script src="js/commands/selectinvert.js"></script>
    <script src="js/commands/selectnone.js"></script>
    <script src="js/commands/sort.js"></script>
    <script src="js/commands/undo.js"></script>
    <script src="js/commands/up.js"></script>
    <script src="js/commands/upload.js"></script>
    <script src="js/commands/view.js"></script>

    <!-- elfinder 1.x connector API support (OPTIONAL) -->
    <script src="js/proxy/elFinderSupportVer1.js"></script>

    <!-- Extra contents editors (OPTIONAL) -->
    <script src="js/extras/editors.default.js"></script>

    <!-- GoogleDocs Quicklook plugin for GoogleDrive Volume (OPTIONAL) -->
    <script src="js/extras/quicklook.googledocs.js"></script>

    <!-- elfinder initialization  -->
    <script>
        function getUrlParam(paramName) {
            var reParam = new RegExp('(?:[\?&]|&amp;)' + paramName + '=([^&]+)', 'i');
            var match = window.location.search.match(reParam);

            return (match && match.length > 1) ? match[1] : '';
        }
        $(function () {

            var funcNum = getUrlParam('CKEditorFuncNum');
            var mode = getUrlParam('mode');

            $('#elfinder').elfinder(
                // 1st Arg - options
                {
                    lang : 'tr',
                    // Disable CSS auto loading
                    cssAutoLoad: false,

                    // Base URL to css/*, js/*
                    baseUrl: './',

                    // Connector URL
                    url: 'php/connector.minimal.php?mode=' + mode,
                    closeOnEditorCallback: true,
                    selectMultiple: false,
                    width: "100%",
                    height:$(window).height()-50,

                    // Callback when a file is double-clicked
                    getFileCallback: function (file) {

                        console.log(file);

                        window.opener.CKEDITOR.tools.callFunction(funcNum, file.url);
                        window.close();

                        if ($('input#cke_105_textInput').is(':visible')) {
                            $('input#cke_105_textInput').val(url);
                        } else {
                            $('input#cke_345_textInput').val(url);
                        }

                        $('a.ui-dialog-titlebar-close[role="button"]').click()
                    },
                    editorCallback: function (url) {
                        window.opener.CKEDITOR.tools.callFunction(funcNum, url, function () {
                            var element, dialog = this.getDialog();

                            if (dialog.getName() == 'link') {
                                element = dialog.getContentElement('info', 'protocol');
                                if (element) {
                                    element.setValue("");
                                }
                            }

                        });
                        window.close();
                    },
                    resizable: false
                },

                // 2nd Arg - before boot up function
                function (fm, extraObj) {
                    // `init` event callback function
                    fm.bind('init', function () {
                        // Optional for Japanese decoder "extras/encoding-japanese.min"
                        delete fm.options.rawStringDecoder;
                        if (fm.lang === 'ja') {
                            fm.loadScript(
                                [fm.baseUrl + 'js/extras/encoding-japanese.min.js'],
                                function () {
                                    if (window.Encoding && Encoding.convert) {
                                        fm.options.rawStringDecoder = function (s) {
                                            return Encoding.convert(s, {to: 'UNICODE', type: 'string'});
                                        };
                                    }
                                },
                                {loadType: 'tag'}
                            );
                        }
                    });

                    // Optional for set document.title dynamically.
                    var title = document.title;
                    fm.bind('open', function () {
                        var path = '',
                            cwd = fm.cwd();
                        if (cwd) {
                            path = fm.path(cwd.hash) || null;
                        }
                        document.title = path ? path + ':' + title : title;
                    }).bind('destroy', function () {
                        document.title = title;
                    });
                }
            );
        });
        $(window).resize(function(){
            var h = ($(window).height()-50);
            if($('#elfinder').height() != h){
                $('#elfinder').height(h).resize();
            }
        });
    </script>
</head>
<body>
<div id="elfinder"></div>
</body>
</html>
