/**
 * @license Copyright (c) 2003-2021, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see https://ckeditor.com/legal/ckeditor-oss-license
 */

CKEDITOR.editorConfig = function( config ) {
    // Define changes to default configuration here. For example:
    config.language = 'tr';
    //config.uiColor = '#dddddd';

    config.filebrowserBrowseUrl         = '../edit/elfinder/elfinder.php?mode=file';
    config.filebrowserImageBrowseUrl    = '../edit/elfinder/elfinder.php?mode=image';
    config.filebrowserFlashBrowseUrl    = '../edit/elfinder/elfinder.php?mode=flash';
    config.EnterMode = 'br' ;			// p | div | br
    config.ShiftEnterMode = 'div' ;	// p | div | br
    config.allowedContent = true;
    config.toolbar = 'Basic';
    config.toolbar_Basic =
        [
            ['Bold', 'Italic', '-', 'NumberedList', 'BulletedList', '-', 'Link', 'Unlink','-','About']
        ];

    config.toolbar = 'Full';
    // This is actually the default value.
    config.toolbar_Full =
        [
            { name: 'document',    items : [ 'Source','-','Save','NewPage','DocProps','Preview','Print','-','Templates' ] },
            { name: 'clipboard',   items : [ 'Cut','Copy','Paste','PasteText','PasteFromWord','-','Undo','Redo' ] },
            { name: 'editing',     items : [ 'Find','Replace','-','SelectAll','-','SpellChecker', 'Scayt' ] },
            // { name: 'forms',       items : [ 'Form', 'Checkbox', 'Radio', 'TextField', 'Textarea', 'Select', 'Button', 'ImageButton', 'HiddenField' ] },
            '/',
            { name: 'basicstyles', items : [ 'Bold','Italic','Underline','Strike','Subscript','Superscript','-','RemoveFormat' ] },
            { name: 'paragraph',   items : [ 'NumberedList','BulletedList','-','Outdent','Indent','-','Blockquote','CreateDiv','-','JustifyLeft','JustifyCenter','JustifyRight','JustifyBlock','-','BidiLtr','BidiRtl' ] },
            { name: 'links',       items : [ 'Link','Unlink','Anchor' ] },
            //{ name: 'insert',      items : [ 'Image','Flash','Table','HorizontalRule','Smiley','SpecialChar','PageBreak' ] },
            '/',
            { name: 'styles',      items : [ 'Image','Flash','Table','HorizontalRule','Smiley','SpecialChar','PageBreak' ,'Styles','Format','Font','FontSize', 'TextColor','BGColor', 'Maximize', 'ShowBlocks'] },
            //{ name: 'colors',      items : [ 'TextColor','BGColor' ] },
            //{ name: 'tools',       items : [ 'Maximize', 'ShowBlocks','-','About' ] }
        ];
    config.protectedSource.push(/<i[^>]*><\/i>/g);
};
